import java.util.*;

// Referenced classes of package duggelz.jape:
//            BasicStructure, ByteField, ChoiceField, IntField,
//            Item, JapeAlg, Skill, StringField

public class Mercenary extends BasicStructure {

    public Mercenary(byte rawData[], int table[]) {
        super(classFields);
        items = new Item[19];
        decode(rawData, table);
    }

    public void decode(byte rawData[], int table[]) {
        allData = new byte[rawData.length];
        System.arraycopy(rawData, 0, allData, 0, allData.length);
        byte ciphertext[] = new byte[2328];
        System.arraycopy(rawData, 1, ciphertext, 0, 2328);
        byte plaintext[] = JapeAlg.Decode(ciphertext, ciphertext.length, table);
        super.data = plaintext;
        for (int idx = 0; idx < 19; idx++) {
            byte itemData[] = new byte[36];
            int itemOffset = 12 + idx * 36;
            System.arraycopy(super.data, itemOffset, itemData, 0, 36);
            Item item = new Item(itemData);
            items[idx] = item;
        }

    }

    public byte[] encode(int table[]) {
        for (int idx = 0; idx < 19; idx++) {
            Item item = items[idx];
            byte itemData[] = item.encode();
            int itemOffset = 12 + idx * 36;
            System.arraycopy(itemData, 0, super.data, itemOffset, 36);
        }

        recomputeChecksum();
        byte rawData[] = new byte[allData.length];
        System.arraycopy(allData, 0, rawData, 0, allData.length);
        byte plaintext[] = new byte[2328];
        System.arraycopy(super.data, 0, plaintext, 0, 2328);
        byte ciphertext[] = JapeAlg.Encode(plaintext, plaintext.length, table);
        System.arraycopy(ciphertext, 0, rawData, 1, 2328);
        return rawData;
    }

    public void recomputeChecksum() {
        int checksum = JapeAlg.MercChecksum(super.data);
        super.data[2208] = (byte) (checksum & 0xff);
        super.data[2209] = (byte) (checksum >> 8 & 0xff);
        super.data[2210] = (byte) (checksum >> 16 & 0xff);
        super.data[2211] = (byte) (checksum >> 24 & 0xff);
    }




    public static final int CIPHERTEXT_OFFSET = 1;
    public static final int CIPHERTEXT_LENGTH = 2328;
    public static final int FIRST_ITEM_OFFSET = 12;
    public static final int ITEM_LENGTH = 36;
    public static final int ITEM_COUNT = 19;
    public static final int HELMET_INDEX = 0;
    public static final int BODY_ARMOR_INDEX = 1;
    public static final int LEG_ARMOR_INDEX = 2;
    public static final int HEADGEAR_1_INDEX = 3;
    public static final int HEADGEAR_2_INDEX = 4;
    public static final int RIGHT_HAND_INDEX = 5;
    public static final int LEFT_HAND_INDEX = 6;
    public static final int BACKPACK_1_3_INDEX = 7;
    public static final int BACKPACK_2_3_INDEX = 8;
    public static final int BACKPACK_3_3_INDEX = 9;
    public static final int BACKPACK_4_3_INDEX = 10;
    public static final int BACKPACK_1_1_INDEX = 11;
    public static final int BACKPACK_2_1_INDEX = 12;
    public static final int BACKPACK_3_1_INDEX = 13;
    public static final int BACKPACK_4_1_INDEX = 14;
    public static final int BACKPACK_1_2_INDEX = 15;
    public static final int BACKPACK_2_2_INDEX = 16;
    public static final int BACKPACK_3_2_INDEX = 17;
    public static final int BACKPACK_4_2_INDEX = 18;
    public static final int ENERGY_OFFSET = 711;
    public static final int MAX_ENERGY_OFFSET = 712;
    public static final int NICK_OFFSET = 730;
    public static final int NICK_LENGTH = 20;
    public static final int SKILL1_OFFSET = 832;
    public static final int SKILL2_OFFSET = 833;
    public static final int DEX_OFFSET = 840;
    public static final int WIS_OFFSET = 841;
    public static final int LVL_OFFSET = 849;
    public static final int HEALTH_OFFSET = 868;
    public static final int AGI_OFFSET = 880;
    public static final int STR_OFFSET = 886;
    public static final int LDR_OFFSET = 895;
    public static final int MEC_OFFSET = 916;
    public static final int MAX_HEALTH_OFFSET = 917;
    public static final int HEAD_OFFSET = 924;
    public static final int PANTS_OFFSET = 954;
    public static final int VEST_OFFSET = 984;
    public static final int SKIN_OFFSET = 1014;
    public static final int MED_OFFSET = 1372;
    public static final int MRK_OFFSET = 1377;
    public static final int EXP_OFFSET = 1378;
    public static final int MORALE_OFFSET = 1736;
    public static final int CHECKSUM_OFFSET = 2208;
    public static final int CHECKSUM_LENGTH = 4;
    public static Hashtable classFields;
    public byte allData[];
    public Item items[];
    public int adjustCount;

    static {
        classFields = new Hashtable();
        classFields.put("Energy", new ByteField(711));
        classFields.put("Max Energy", new ByteField(712));
        classFields.put("Nickname", new StringField(730, 20));
        classFields.put("Skill1",
                        new ChoiceField(new ByteField(832), Skill.table));
        classFields.put("Skill2",
                        new ChoiceField(new ByteField(833), Skill.table));
        classFields.put("Dexterity", new ByteField(840));
        classFields.put("Wisdom", new ByteField(841));
        classFields.put("Level", new ByteField(849));
        classFields.put("Health", new ByteField(868));
        classFields.put("Agility", new ByteField(880));
        classFields.put("Strength", new ByteField(886));
        classFields.put("Leadership", new ByteField(895));
        classFields.put("Mechanical", new ByteField(916));
        classFields.put("Max Health", new ByteField(917));
        classFields.put("Head", new ByteField(924));
        classFields.put("Pants", new ByteField(954));
        classFields.put("Vest", new ByteField(984));
        classFields.put("Skin", new ByteField(1014));
        classFields.put("Medical", new ByteField(1372));
        classFields.put("Marksmanship", new ByteField(1377));
        classFields.put("Explosives", new ByteField(1378));
        classFields.put("Morale", new ByteField(1736));
        classFields.put("Checksum", new IntField(2208));
    }
}
